#include <iostream>
#include <vector>
#include <queue>

using namespace std;

struct Room {
    int id;
    int jumpLimit;
    int changes;

    Room(int id, int jumpLimit, int changes) : id(id), jumpLimit(jumpLimit), changes(changes) {}
};

int main() {
    int N;
    cin >> N;

    vector<int> jumpLimit(N + 1);
    vector<int> changes(N + 1, 0);

    for (int i = 1; i < N; ++i) {
        int U, V;
        cin >> U >> V;
    }

    for (int i = 1; i <= N; ++i) {
        cin >> jumpLimit[i];
    }

    for (int i = 1; i <= N; ++i) {
        cin >> changes[i];
    }

    vector<int> result(N + 1, -1);

    queue<Room> q;
    q.push(Room(1, jumpLimit[1], changes[1]));

    while (!q.empty()) {
        Room current = q.front();
        q.pop();

        if (result[current.id] != -1) {
            continue;
        }

        result[current.id] = current.changes;

        for (int neighbor = current.id + 1; neighbor <= N; ++neighbor) {
            if (neighbor <= current.id + current.jumpLimit) {
                q.push(Room(neighbor, jumpLimit[neighbor], current.changes));
            } else {
                if (changes[neighbor] != 0) {
                    q.push(Room(neighbor, jumpLimit[neighbor], current.changes + 1));
                } else {
                    break;
                }
            }
        }
    }

    for (int i = 1; i <= N; ++i) {
        cout << result[i] << " ";
    }

    return 0;
}